<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HisobotController extends Controller
{
	public function ostatkaTovara(Request $request) { 
		
	     $sana = $request->json()->get("sana");
	     $brend_id = $request->json()->get("brend_id");
	     $maxsulot_id = $request->json()->get("maxsulot_id");
	     
		 $brend_sql = "SELECT brend_id, brend_nomi, SUM(qoldiq) as jami_soni, SUM(CASE WHEN valyuta_turi = 1 THEN qoldiq * sotish_narxi ELSE 0 END) as summa_val,SUM(CASE WHEN valyuta_turi = 2 THEN qoldiq * sotish_narxi ELSE 0 END) as summa_som FROM (SELECT tovarlar.*, ostatka.time_create as vaqt, brendlar.nomi as brend_nomi, SUM(CASE WHEN ostatka.prixod_rasxod_turi = 1 THEN (ostatka.miqdor * 1) ELSE (ostatka.miqdor * -1) END) as qoldiq FROM ostatka LEFT JOIN tovarlar ON ostatka.element_id = tovarlar.Id LEFT JOIN brendlar ON tovarlar.brend_id = brendlar.Id GROUP BY ostatka.element_id) as brend_boy ";
		 
		 $tovar_sql = "SELECT tovarlar.*, olchov_turlari.nomi as olchov_turi, brendlar.nomi as brend_nomi, SUM(CASE WHEN ostatka.prixod_rasxod_turi = 1 THEN (ostatka.miqdor * 1) ELSE (ostatka.miqdor * -1) END) as qoldiq FROM ostatka LEFT JOIN tovarlar ON ostatka.element_id = tovarlar.Id LEFT JOIN brendlar ON tovarlar.brend_id = brendlar.Id LEFT JOIN olchov_turlari ON tovarlar.olchov_id = olchov_turlari.Id WHERE brend_id = ? ";
		 $start = "";
		 $start2 = ""; 

		 if($sana){
		     $start = " WHERE vaqt < '{$sana} 23:59:59'";
		     $start2 = " AND ostatka.time_create < '{$sana} 23:59:59'";
		 } else {
		    $start = " WHERE 1=1";  
		 }
	       
	     if($brend_id) {
	          $start = $start." AND brend_id = '".$brend_id."'";
	     } 
	     
	     
	     if($maxsulot_id) {
	        $start = $start." AND Id = '".$maxsulot_id."'";
	        $start2 = $start2." AND tovarlar.Id = '".$maxsulot_id."'";
	     }
	     
	       $brend_sql = $brend_sql.$start." GROUP BY brend_id order by brend_nomi"; 
	        $tovar_sql = $tovar_sql.$start2." GROUP BY ostatka.element_id order by tovarlar.nomi";   
	        
	        
	        $brend_data = DB::select($brend_sql);  
	       // return $tovar_sql."<br>".$brend_sql;
		
		
      $thead1 = [
            ["title"=> "№", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Махсулот номи", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Валюта тури", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Ўлчов бирлиги", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Сони", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Блок", "rowspan"=> 1, "colspan"=> 2],
            ["title"=> "Қолдиқ", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Нархи", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Нархи-вал", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Сумма", "rowspan"=> 2, "colspan"=> 1],
            ["title"=> "Сумма-вал", "rowspan"=> 2, "colspan"=> 1],
    	];
    	$thead2 = [
         ["title"=> "Блок", "rowspan"=> 1, "colspan"=> 1],
         ["title"=> "Сони", "rowspan"=> 1, "colspan"=> 1],
    	];
		
		
	   
	  
	   //table generator function
	   include(app()->basePath('app'). "/Functions/TableGenerator.php"); 
	   
	   
	   $table = tableGen(theadGen($thead1), $table);
	   $table = tableGen(theadGen($thead2), $table);
	   $table = $table."<tbody>";
	   $brendTartib = 1;
	   $tovarTartib = 1;
	   foreach( $brend_data as $brend) {
	       $eachRow = [
	           ["title"=> $brendTartib, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> $brend->brend_nomi, "rowspan"=> 1, "colspan"=> 6, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($brend->jami_soni), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($brend->summa_som), "rowspan"=> 1, "colspan"=> 3, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true],
	           ["title"=> $brend->summa_val, "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#339966", "bold"=> true],
	       ];
	       $table = tableGen(bodyGen($eachRow), $table);
	       
	       $tovarlar = DB::select($tovar_sql, [$brend->brend_id]);
	       
	       foreach ($tovarlar as $tovar) {
	           
	           $tovarRow = [
	             ["title"=> $tovarTartib, "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->nomi, "rowspan"=> 1, "colspan"=> 1, "align"=> "left", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->valyuta_turi == 1 ? "Вал" : "Сўм", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->olchov_turi, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->blok_soni, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->qoldiq > 0 ? ($tovar->qoldiq - $tovar->qoldiq % $tovar->blok_soni)/$tovar->blok_soni : "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->qoldiq % $tovar->blok_soni, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#339966"],
	             ["title"=> $tovar->qoldiq, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->valyuta_turi == 2 ? num_format($tovar->sotish_narxi) : "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#536ac2"],
	             ["title"=> $tovar->valyuta_turi == 1 ? $tovar->sotish_narxi : "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#339966"],
	             ["title"=> $tovar->valyuta_turi == 2 ? num_format($tovar->qoldiq * $tovar->sotish_narxi) : "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#536ac2"],
	             ["title"=> $tovar->valyuta_turi == 1 ? $tovar->qoldiq * $tovar->sotish_narxi : "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#339966"],
	           ];
	          $table = tableGen(bodyGen($tovarRow), $table);
	           $tovarTartib = $tovarTartib + 1;    
	       }
	       
	           
	       $brendTartib = $brendTartib + 1;    
	   }
	   
	   $table = $table."</tbody>";
	  
	  
	  $table = $table."</table></body></html>";
	   $html =   $styles."<div class='print_header_hisobot'> <h2>Маҳсулот қолдиги</h2><h5>".$sana." - кун якунига</h5> </div><table id='customers'>".$table;
	   return ["html"=> $html];
    }
    
    public function mijozAktsverka(Request $request) {
        
         $sana = $request->json()->get("sana");
         $sana2 = $request->json()->get("sana2");
         $mijoz_id = $request->json()->get("mijoz_id");
         
         $sql = "SELECT * FROM `qarzdorlik_mijoz` WHERE mijoz_id = ? AND time_create >= ? AND  time_create <? ";
         
         //table generator function
	     include(app()->basePath('app'). "/Functions/TableGenerator.php"); 
          $start = "";
          

	     
	   $mijoz = DB::select("select fio from xodimlar where Id = ?", [$mijoz_id]);  
	     
	   $thead1 = [
            ["title"=> "Жараёнлар", "rowspan"=> 3, "colspan"=> 2],
            ["title"=> $mijoz[0]->fio, "rowspan"=> 1, "colspan"=> 4],
    	];
    	$thead2 = [
         ["title"=> "Сўм", "rowspan"=> 1, "colspan"=> 2],
         ["title"=> "Валюта", "rowspan"=> 1, "colspan"=> 2],
    	];
    	
    	$thead3 = [
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	 ];
	     
	     
	    
	    $table = tableGen(theadGen($thead1), $table);
	    $table = tableGen(theadGen($thead2), $table);
	    $table = tableGen(theadGen($thead3), $table);
	     
	    $bosh_qarzi = DB::select("SELECT SUM(CASE WHEN turi = 1 THEN (summa_som * 1) WHEN turi = 2 THEN (summa_som * -1) ELSE 0 END) as summa_som, CAST(SUM(CASE WHEN turi = 1 THEN (summa_val * 1) WHEN turi = 2 THEN (summa_val * -1) ELSE 0 END) as DECIMAL(14,2)) as summa_val FROM `qarzdorlik_mijoz` WHERE mijoz_id = ? AND time_create <= ? GROUP BY mijoz_id", [$mijoz_id, $sana]);
	     
	     $bosh_row = [];
	     if(count($bosh_qarzi) > 0) {
	         $bosh_row =  [
	           ["title"=> "Қарздорлик-хақдорлик $sana", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  num_format($bosh_qarzi[0]->summa_som), "rowspan"=> 1, "colspan"=>2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	
	           ["title"=>  num_format($bosh_qarzi[0]->summa_val), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	        
	         
	         ];
	     }else {
	          $bosh_row =  [
	           ["title"=> "Қарздорлик-хақдорлик $sana", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	        
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	          
	         
	         ];
	     }
	     
	     $table = tableGen(bodyGen($bosh_row), $table);
	     
	     
	     
	     
        $tolovlar = DB::select($sql, [$mijoz_id, $sana." 00:00:01", $sana2." 23:59:59"]);
        foreach ($tolovlar as $tolov) {
            
            $tolovRow = [
                   ["title"=> "$tolov->table_name ID:$tolov->document_id $tolov->time_update", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> $tolov->turi == 2 ? num_format($tolov->summa_som * 1): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> $tolov->turi == 1 ? num_format($tolov->summa_som * 1): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> $tolov->turi == 2 ? num_format($tolov->summa_val): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000","bold"=>true],
                   ["title"=> $tolov->turi == 1 ? num_format($tolov->summa_val): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000","bold"=>true],
                ];
                
                $table = tableGen(bodyGen($tolovRow), $table);
        }
        
         
         
         $ora_qarzi = DB::select("SELECT time_update, SUM(CASE WHEN turi = 1 THEN summa_som * 1 ELSE 0 END) AS summa_d_som, SUM(CASE WHEN turi = 2 THEN summa_som * 1 ELSE 0 END) AS summa_k_som, CAST( SUM(CASE WHEN turi = 1 THEN summa_val *1 ELSE 0 END) AS DECIMAL(14, 2) ) AS summa_d_val, CAST( SUM(CASE WHEN turi = 2 THEN summa_val * 1 ELSE 0 END) AS DECIMAL(14, 2) ) AS summa_k_val FROM `qarzdorlik_mijoz` WHERE mijoz_id = ? AND time_create >= '$sana 00:00:00' AND time_create <= '$sana2 23:59:59'  GROUP BY mijoz_id", [$mijoz_id, $sana, $sana2]);
         $ora_row = [];
	     if(count($ora_qarzi) > 0) {
	         $ora_row =  [
	           ["title"=> "Давр мобайнида", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=> num_format($ora_qarzi[0]->summa_k_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=>  num_format($ora_qarzi[0]->summa_d_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  num_format($ora_qarzi[0]->summa_k_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($ora_qarzi[0]->summa_d_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true]
	         
	         ];
	     }else {
	           $ora_row =  [
	           ["title"=> "Давр мобайнида", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true]
	         
	         ];
	     }
         $table = tableGen(bodyGen($ora_row), $table);
        
        //yakuniy qarzi
        $end_qarzi = DB::select("SELECT SUM(CASE WHEN turi = 2 THEN (summa_som * 1) WHEN turi = 1 THEN (summa_som * -1) ELSE 0 END) as summa_som, CAST(SUM(CASE WHEN turi = 2 THEN (summa_val * 1) WHEN turi = 1 THEN (summa_val * -1) ELSE 0 END) as DECIMAL(14,2)) as summa_val FROM `qarzdorlik_mijoz` WHERE mijoz_id = ? AND time_create <= '$sana2 23:59:59' GROUP BY mijoz_id", [$mijoz_id]);
	     
	  
	     $end_row = [];
	     if(count($end_qarzi) > 0) {
	         $end_row =  [
	           ["title"=> " давр якунида $sana2", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=>  num_format($end_qarzi[0]->summa_som), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	         
	           ["title"=> num_format($end_qarzi[0]->summa_val), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	        
	         
	         ];
	     }else {
	           $end_row =  [
	           ["title"=> " давр якунида $sana2", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	        
	        
	         
	         ];
	     }
	     
	     $table = tableGen(bodyGen($end_row), $table);

         $table = $table."</tbody>";
	  
	  
	  $table = $table."</table></body></html>";
	   $html =  $styles."<div class='print_header_hisobot'> <h2>Мижоз Акт сверка</h2><h5>".$sana." - ".$sana2." давр ичида</h5> </div><table id='customers'>".$table; 
	   return ["html"=> $html];
    }
    
    
    
    
    
    // yuk beruvchi aktsverka
    public function yukAktsverka(Request $request) {
        
         $sana = $request->json()->get("sana");
         $sana2 = $request->json()->get("sana2");
         $yuk_beruvchi_id = $request->json()->get("yuk_beruvchi_id");
         
         
         $sql = "SELECT * FROM `qarzdorlik_yukberuvchi` WHERE yuk_beruvchi_id = ? AND time_create >= ? AND  time_create <? ";
         
         //table generator function
	     include(app()->basePath('app'). "/Functions/TableGenerator.php"); 
          $start = "";
          
      
	     
	   $mijoz = DB::select("select fio from yukBeruvchi where Id = ?", [$yuk_beruvchi_id]);  
	    
	   $thead1 = [
            ["title"=> "Жараёнлар", "rowspan"=> 3, "colspan"=> 2],
            ["title"=> $mijoz[0]->fio, "rowspan"=> 1, "colspan"=> 4],
    	];
    	$thead2 = [
         ["title"=> "Сўм", "rowspan"=> 1, "colspan"=> 2],
         ["title"=> "Валюта", "rowspan"=> 1, "colspan"=> 2],
    	];
    	
    	$thead3 = [
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	 ];
	     
	     
	    
	    $table = tableGen(theadGen($thead1), $table);
	    $table = tableGen(theadGen($thead2), $table);
	    $table = tableGen(theadGen($thead3), $table);
	     
	    $bosh_qarzi = DB::select("SELECT SUM(CASE WHEN turi = 1 THEN (summa_som * 1) WHEN turi = 2 THEN (summa_som * -1) ELSE 0 END) as summa_som, CAST(SUM(CASE WHEN turi = 1 THEN (summa_val * 1) WHEN turi = 2 THEN (summa_val * -1) ELSE 0 END) as DECIMAL(14,2)) as summa_val FROM `qarzdorlik_yukberuvchi` WHERE yuk_beruvchi_id = ? AND time_create <= ? GROUP BY yuk_beruvchi_id", [$yuk_beruvchi_id, $sana]);
	     
	     $bosh_row = [];
	     if(count($bosh_qarzi) > 0) {
	         $bosh_row =  [
	           ["title"=> "Қарздорлик-хақдорлик $sana", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  num_format($bosh_qarzi[0]->summa_som), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	          
	           ["title"=>  num_format($bosh_qarzi[0]->summa_val ), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	         
	         ];
	     }else {
	          $bosh_row =  [
	           ["title"=> "Қарздорлик-хақдорлик $sana", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	       
	         
	         ];
	     }
	     
	     $table = tableGen(bodyGen($bosh_row), $table);
	     
	     
	     
	     
        $tolovlar = DB::select($sql, [$yuk_beruvchi_id, $sana." 00:00:01", $sana2." 23:59:59"]);
        foreach ($tolovlar as $tolov) {
            
            $tolovRow = [
                   ["title"=> "$tolov->table_name ID:$tolov->document_id $tolov->time_update", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> $tolov->turi == 2 ? num_format($tolov->summa_som * 1): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> $tolov->turi == 1 ? num_format($tolov->summa_som * 1): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> $tolov->turi == 2 ? num_format($tolov->summa_val): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000","bold"=>true],
                   ["title"=> $tolov->turi == 1 ? num_format($tolov->summa_val): "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000","bold"=>true],
                ];
                
                $table = tableGen(bodyGen($tolovRow), $table);
        }
        
         
         
         $ora_qarzi = DB::select("SELECT time_update, SUM(CASE WHEN turi = 1 THEN summa_som * 1 ELSE 0 END) AS summa_d_som, SUM(CASE WHEN turi = 2 THEN summa_som * 1 ELSE 0 END) AS summa_k_som, CAST( SUM(CASE WHEN turi = 1 THEN summa_val *1 ELSE 0 END) AS DECIMAL(14, 2) ) AS summa_d_val, CAST( SUM(CASE WHEN turi = 2 THEN summa_val * 1 ELSE 0 END) AS DECIMAL(14, 2) ) AS summa_k_val FROM `qarzdorlik_yukberuvchi` WHERE yuk_beruvchi_id = ? AND time_create >= '$sana 00:00:00' AND time_create <= '$sana2 23:59:59'  GROUP BY yuk_beruvchi_id", [$yuk_beruvchi_id]);
         $ora_row = [];
	     if(count($ora_qarzi) > 0) {
	         $ora_row =  [
	           ["title"=> "Давр мобайнида", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=> num_format($ora_qarzi[0]->summa_k_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=>  num_format($ora_qarzi[0]->summa_d_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  num_format($ora_qarzi[0]->summa_k_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($ora_qarzi[0]->summa_d_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true]
	         
	         ];
	     }else {
	           $ora_row =  [
	           ["title"=> "Давр мобайнида", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> "", "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true]
	         
	         ];
	     }
         $table = tableGen(bodyGen($ora_row), $table);
        
        //yakuniy qarzi
        $end_qarzi = DB::select("SELECT SUM(CASE WHEN turi = 2 THEN (summa_som * 1) WHEN turi = 1 THEN (summa_som * -1) ELSE 0 END) as summa_som, CAST(SUM(CASE WHEN turi = 2 THEN (summa_val * 1) WHEN turi = 1 THEN (summa_val * -1) ELSE 0 END) as DECIMAL(14,2)) as summa_val FROM `qarzdorlik_yukberuvchi` WHERE yuk_beruvchi_id = ? AND time_create <= '$sana2 23:59:59' GROUP BY yuk_beruvchi_id", [$yuk_beruvchi_id]);
	     
	     $end_row = [];
	     if(count($end_qarzi) > 0) {
	         $end_row =  [
	           ["title"=> " давр якунида $sana2", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=> num_format($end_qarzi[0]->summa_som), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	          
	           ["title"=>  num_format($end_qarzi[0]->summa_val), "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	         
	         
	         ];
	     }else {
	           $end_row =  [
	           ["title"=> " давр якунида $sana2", "rowspan"=> 1, "colspan"=> 2, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#2F49D1","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=>  "", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	        
	         
	         ];
	     }
	     
	     $table = tableGen(bodyGen($end_row), $table);

         $table = $table."</tbody>";
	  
	  
	  $table =$table."</table></body></html>";
	   $html =  $styles."<div class='print_header_hisobot'> <h2>Юк берувчи Акт сверка</h2><h5>".$sana." - ".$sana2." давр ичида</h5> </div><table id='customers'>".$table; 
	   return ["html"=> $html];
    }
    
    
    public function mijozlarQoldigi(Request $request) {
        
         $sana = $request->json()->get("sana");
        //  $sana2 = $request->json()->get("sana2");
         $mijoz_id = $request->json()->get("mijoz_id");
        
        $mijoz_sql = "";
        if($mijoz_id) {
            $mijoz_sql = " AND xodimlar.Id=$mijoz_id"; 
        }
        
            
         $sql = "SELECT xodimlar.fio, qarz.* FROM xodimlar LEFT JOIN ( SELECT
    qarzdorlik_mijoz.mijoz_id as mijoz_id,
    SUM(
        CASE WHEN qarzdorlik_mijoz.turi = 1 THEN summa_som * 1 ELSE 0
    END
) AS summa_d_som,
SUM(
    CASE WHEN qarzdorlik_mijoz.turi = 2 THEN summa_som * 1 ELSE 0
END
) AS summa_k_som,
CAST(
    SUM(
        CASE WHEN qarzdorlik_mijoz.turi = 1 THEN summa_val * 1 ELSE 0
    END
) AS DECIMAL(14, 2)
) AS summa_d_val,
CAST(
    SUM(
        CASE WHEN qarzdorlik_mijoz.turi = 2 THEN summa_val * 1 ELSE 0
    END
) AS DECIMAL(14, 2)
) AS summa_k_val
FROM
    `qarzdorlik_mijoz`
    WHERE time_create <= '$sana 23:59:59'
    GROUP BY mijoz_id) as qarz ON xodimlar.Id= qarz.mijoz_id WHERE xodimlar.turi = 3 $mijoz_sql";
         
         //table generator function
	     include(app()->basePath('app'). "/Functions/TableGenerator.php"); 
 
	   $thead1 = [
	       ["title"=> "№", "rowspan"=> 3, "colspan"=> 1],
            ["title"=> "Мижозлар", "rowspan"=> 3, "colspan"=> 1],
             
    	];
    	$thead2 = [
         ["title"=> "Сўм", "rowspan"=> 1, "colspan"=> 2],
         ["title"=> "Валюта", "rowspan"=> 1, "colspan"=> 2],
    	];
    	
    	$thead3 = [
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	 ];
	     
	     
	    
	    $table = tableGen(theadGen($thead1), $table);
	    $table = tableGen(theadGen($thead2), $table);
	    $table = tableGen(theadGen($thead3), $table);
	     
	 
	   
	     
	     
	     
        $tolovlar = DB::select($sql, [$mijoz_id]);
        $tar = 1;
        foreach ($tolovlar as $tolov) {
            $tolovRow = [
                 ["title"=> "$tar", "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> "$tolov->fio", "rowspan"=> 1, "colspan"=> 1, "align"=> "left", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> num_format($tolov->summa_k_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=>  num_format($tolov->summa_d_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  num_format($tolov->summa_k_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($tolov->summa_d_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true]
                ];
                
                $tar = $tar +1;
                $table = tableGen(bodyGen($tolovRow), $table);
        }
        
    
         $table = $table."</tbody>";
	  
	  
	  $table = $table."</table></body></html>";
	   $html = $styles."<div class='print_header_hisobot'> <h2>Мижозлар қолдиғи</h2><h5>".$sana." бўйича</h5> </div><table id='customers'>".$table;
	   
	   
	   return ["html"=> $html];
    }
    
    
    
    public function yukBeruvchilarQoldigi(Request $request) {
        
         $sana = $request->json()->get("sana");
         $yuk_beruvchi_id = $request->json()->get("yuk_beruvchi_id");
        
        $yuk_sql = "";
        if($yuk_beruvchi_id) {
            $yuk_sql = " WHERE yukBeruvchi.Id=$yuk_beruvchi_id"; 
        }
        
            
         $sql = "SELECT yukBeruvchi.fio, qarz.* FROM yukBeruvchi LEFT JOIN (SELECT
    qarzdorlik_yukberuvchi.yuk_beruvchi_id as yuk_id,
    SUM(
        CASE WHEN qarzdorlik_yukberuvchi.turi = 1 THEN summa_som * 1 ELSE 0
    END
) AS summa_d_som,
SUM(
    CASE WHEN qarzdorlik_yukberuvchi.turi = 2 THEN summa_som * 1 ELSE 0
END
) AS summa_k_som,
CAST(
    SUM(
        CASE WHEN qarzdorlik_yukberuvchi.turi = 1 THEN summa_val * 1 ELSE 0
    END
) AS DECIMAL(14, 2)
) AS summa_d_val,
CAST(
    SUM(
        CASE WHEN qarzdorlik_yukberuvchi.turi = 2 THEN summa_val * 1 ELSE 0
    END
) AS DECIMAL(14, 2)
) AS summa_k_val
FROM  `qarzdorlik_yukberuvchi`
    WHERE time_create < '$sana 23:59:59'
    GROUP BY qarzdorlik_yukberuvchi.yuk_beruvchi_id) as qarz ON yukBeruvchi.Id= qarz.yuk_id $yuk_sql";
         
         //table generator function
	     include(app()->basePath('app'). "/Functions/TableGenerator.php"); 
 
	   $thead1 = [
	       ["title"=> "№", "rowspan"=> 3, "colspan"=> 1],
            ["title"=> "Мижозлар", "rowspan"=> 3, "colspan"=> 1],
             
    	];
    	$thead2 = [
         ["title"=> "Сўм", "rowspan"=> 1, "colspan"=> 2],
         ["title"=> "Валюта", "rowspan"=> 1, "colspan"=> 2],
    	];
    	
    	$thead3 = [
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Хақдорлик", "rowspan"=> 1, "colspan"=> 1],
    	       ["title"=> "Қарздорлик", "rowspan"=> 1, "colspan"=> 1],
    	 ];
	     
	     
	    
	    $table = tableGen(theadGen($thead1), $table);
	    $table = tableGen(theadGen($thead2), $table);
	    $table = tableGen(theadGen($thead3), $table);
	     
	 
	   
	     
	     
	     
        $tolovlar = DB::select($sql, [$yuk_beruvchi_id]);
        $tar = 1;
        foreach ($tolovlar as $tolov) {
            $tolovRow = [
                 ["title"=> "$tar", "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> "$tolov->fio", "rowspan"=> 1, "colspan"=> 1, "align"=> "left", "bgColor"=> "#fff", "color"=> "#000"],
                   ["title"=> num_format($tolov->summa_k_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#536ac2","bold"=>true],
	           ["title"=>  num_format($tolov->summa_d_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=>  num_format($tolov->summa_k_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($tolov->summa_d_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true]
                ];
                
                $tar = $tar +1;
                $table = tableGen(bodyGen($tolovRow), $table);
        }
        
    
         $table = $table."</tbody>";
	  
	  
	  $table = $table."</table></body></html>";
	   $html =  $styles."<div class='print_header_hisobot'> <h2>Юк берувчилар қолдиғи</h2><h5>".$sana." бўйича</h5> </div><table id='customers'>".$table; 
	   
	   return ["html"=> $html];
    }
    
    
    
    
}




