<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AllDataController extends Controller
{
	public function index() { 
        $bolim = DB::table('bolimlar')->select()->orderBy("Id", "desc")->get();

        $brendlar = DB::table('brendlar')->select()->orderBy("Id", "desc")->get();

        $shahar = DB::table('shaharlar')->select()->orderBy("Id", "desc")->get();

        $viloyat = DB::table('viloyatlar')->select()->orderBy("Id", "desc")->get();
        
        $olchov_turlari = DB::table('olchov_turlari')->select()->orderBy("Id", "desc")->get();
        
        
        
        $regionlar = DB::table('regionlar')->select()->orderBy("Id", "desc")->get();
        
        $tovarlar = DB::table('tovarlar')->select()->orderBy("Id", "desc")->get();
        
        $xodimlar = DB::table('xodimlar')->select()->orderBy("Id", "desc")->get();
        
        $yukBeruvchi = DB::table('yukBeruvchi')->select()->orderBy("Id", "desc")->get();
        
        
        $data = ["yukBeruvchi"=> $yukBeruvchi,"xodimlar"=> $xodimlar,"tovarlar"=> $tovarlar,"tovar_turi"=> $bolim,"regionlar"=> $regionlar,"olchov_turlari"=> $olchov_turlari,"brendlar"=> $brendlar, "shahar"=> $shahar, "viloyat"=> $viloyat];
        return $data;

    }
    
    public function alldata(Request $request){
        $data = $request->json()->all();
        
        $allDataSql = [
            "bolimlar"=> "SELECT Id, nomi, img FROM bolimlar",
            "brendlar"=> "SELECT Id, yuk_beruvchi_id, nomi FROM brendlar",
            "shaharlar"=> "SELECT * FROM `shaharlar`", 
            "kassa_turlari"=> "SELECT * FROM kassa_turlari", 
            "viloyatlar"=> "SELECT * FROM `viloyatlar`", 
            "olchov_turlari"=> "SELECT * FROM `olchov_turlari`",
            "regionlar"=> "SELECT * FROM `regionlar`", 
            "tolov_turlari"=> "SELECT * FROM `tolov_turlari`", 
            "tovarlar"=> "SELECT * FROM `tovarlar`",
            "mijozlar"=> "SELECT Id, fio, telefon, manzil, viloyat_id, shahar_id, region_id FROM `xodimlar` WHERE turi = 3", 
            "agentlar"=> "SELECT Id, fio, telefon, manzil, viloyat_id, shahar_id, region_id FROM `xodimlar` WHERE turi = 1", 
            "dostavshik"=> "SELECT Id, fio, telefon, manzil, viloyat_id, shahar_id, region_id FROM `xodimlar` WHERE turi = 2", 
            "users"=> "SELECT * FROM `xodimlar` WHERE turi = 0", 
            "yuk_beruvchilar"=> "SELECT * FROM `yukBeruvchi`",
            "constanta"=> "SELECT JSON_EXTRACT(document, '$.kurs') as kurs, JSON_EXTRACT(document, '$.chegirma') as chegirma  FROM `constanta`",
            "ostatka"=> "SELECT * FROM ( SELECT tovarlar.*, SUM(CASE WHEN ostatka.prixod_rasxod_turi = 1 THEN (ostatka.miqdor * 1) ELSE (ostatka.miqdor * -1) END) as qoldiq FROM ostatka LEFT JOIN tovarlar ON ostatka.element_id = tovarlar.Id GROUP BY ostatka.element_id) as ost WHERE ost.qoldiq > 0"
            
            ];
        
        
        $result = array();
        foreach($data as $value) {
            $a = [$value => DB::select($allDataSql[$value])];
            $result = array_merge($result, $a);
        }
        
        return $result;
        
    }
}




