<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->post('/login', 'LoginController@index');
//alldata
$router->get('/alldata', 'AllDataController@index');
$router->post('/alldata2', 'AllDataController@alldata');
$router->post('/editkurs', 'MobilController@editKurs');

//Mobile Controller
$router->post('/bolimbrendlar', 'MobilController@brendlar');
$router->get('/xodimTarix/{id}', 'MobilController@xodimTarix');
$router->post('/newByDas', 'MobilController@newByDas');
$router->post('/tovarbolim', 'BolimTavarlar@index');
$router->get('/mobilbolimlar', 'MobilController@bolimlar');

// tovar filter bolim 
$router->post('/brendtovarlar', 'BrendTavarlar@index');

// tovar filter bolim 
$router->post('/insertzakaz', 'InsertZakaz@index');


// yukBeruvchi
$router->get('/servis/yukBeruvchi', 'yukBeruvchiController@index');
$router->post('/servis/yukBeruvchi', 'yukBeruvchiController@create');
$router->delete('/servis/yukBeruvchi/{id}', 'yukBeruvchiController@delete');



// brendlar
$router->get('/servis/brendlar', 'brendlarController@index');
$router->post('/servis/brendlar', 'brendlarController@create');
$router->post("/servis/brendlarphoto", 'brendlarController@photo');
$router->delete('/servis/brendlar/{id}', 'brendlarController@delete');


// olchovBirligi
$router->get('/servis/olchovBirligi', 'olchovBirligiController@index');
$router->post('/servis/olchovBirligi', 'olchovBirligiController@create');
$router->delete('/servis/olchovBirligi/{id}', 'olchovBirligiController@delete');


// maxsulot
$router->get('/servis/maxsulot', 'maxsulotController@index');
$router->post('/servis/maxsulot', 'maxsulotController@create');
$router->post("/servis/maxsulotphoto", 'maxsulotController@photo');
$router->delete('/servis/maxsulot/{id}', 'maxsulotController@delete');


// viloyat
$router->get('/servis/viloyat', 'viloyatController@index');
$router->post('/servis/viloyat', 'viloyatController@create');
$router->delete('/servis/viloyat/{id}', 'viloyatController@delete');

// xarajatlar
$router->get('/xarajatturlari', 'xarajatController@xTurlari');
$router->post('/xarajatturlari', 'xarajatController@xTurlaricreate');
$router->delete('/xarajatturlari/{Id}', 'xarajatController@xTurlaridelete');
// xarajat tolov
$router->get('/xarajat-tolov', 'xarajatController@xTolov');
$router->post('/xarajat-tolov', 'xarajatController@xTolovcreate');
$router->delete('/xarajat-tolov/{Id}', 'xarajatController@xTolovdelete');

// shaharTuman
$router->get('/servis/shaharTuman', 'shaharTumanController@index');
$router->post('/servis/shaharTuman', 'shaharTumanController@create');
$router->delete('/servis/shaharTuman/{id}', 'shaharTumanController@delete');


// region
$router->get('/servis/region', 'regionController@index');
$router->post('/servis/region', 'regionController@create');
$router->delete('/servis/region/{id}', 'regionController@delete');


// mijozlar
$router->get('/servis/mijozlar', 'mijozlarController@index');
$router->post('/servis/mijozlar', 'mijozlarController@create');
$router->delete('/servis/mijozlar/{id}', 'mijozlarController@delete');


// xodimlar
$router->get('/servis/xodimlar', 'xodimlarController@index');

$router->get('/servis/xodimlar/{Id}', 'xodimlarController@getOne');
$router->post('/servis/xodimlar', 'xodimlarController@create');
$router->post('/servis/xodimlarlatlng', 'xodimlarController@updateLatLng'); 
$router->delete('/servis/xodimlar/{id}', 'xodimlarController@delete');


// lavozim
$router->get('/servis/lavozim', 'lavozimController@index');
$router->post('/servis/lavozim', 'lavozimController@create');
$router->delete('/servis/lavozim/{id}', 'lavozimController@delete');


// bolimlar
$router->get('/servis/bolimlar', 'bolimlarController@index');
$router->post('/servis/bolimlar', 'bolimlarController@create');
$router->post("/servis/bolimlarphoto", 'bolimlarController@photo');
$router->delete('/servis/bolimlar/{id}', 'bolimlarController@delete');
 
// maxsulot kirim
$router->get('/kirim', 'KirimController@index');
$router->post('/kirim', 'KirimController@create');
$router->delete('/kirim/{id}', 'KirimController@delete');

// sotuv bolimi
$router->get('/sotuvbolimi', 'SotuvController@index');
$router->post('/sotuvbolimi', 'SotuvController@create');
$router->delete('/sotuvbolimi/{id}', 'SotuvController@delete');

// buyurtmalar
$router->get('/buyurtmalar', 'BuyurtmalarController@index');
$router->post('/buyurtmalar', 'BuyurtmalarController@create');
$router->delete('/buyurtmalar/{id}', 'BuyurtmalarController@delete');

// qaytarilganlar
$router->get('/qaytarilganlar', 'QaytarilganlarController@index');
$router->post('/qaytarilganlar', 'QaytarilganlarController@create');
$router->delete('/qaytarilganlar/{id}', 'QaytarilganlarController@delete');

$router->get("/alldata", "AllDataController@index");


// hisobot router 
$router->post('/hisobot', 'HisobotController@index');
$router->post('/hisobot/pribl', 'PriblController@pribl');

// sms routers
$router->post('/sms', 'SMSController@index');
$router->get('/sms', 'SMSController@sms');


// maxsulot_kirimi
$router->get('/maxsulot-kirimi', 'MaxsulotKirimiController@index');
$router->post('/maxsulot-kirimi', 'MaxsulotKirimiController@create');
$router->delete('/maxsulot-kirimi/{Id}', 'MaxsulotKirimiController@delete');



// qoldiq //
$router->get('/maxsulot-qoldigi', 'QoldiqController@maxsulot');
$router->post('/maxsulot-qoldigi', 'QoldiqController@maxsulotCreate');
$router->delete('/maxsulot-qoldigi/{id}', 'QoldiqController@maxsulotDelete');
 // yukbermijoz
$router->get('/yukBeruvchilar-qoldigi', 'QoldiqController@yukberMijoz');
$router->post('/yukBeruvchilar-qoldigi', 'QoldiqController@yukberMijozCreate');
$router->delete('/yukBeruvchilar-qoldigi/{id}', 'QoldiqController@yukberMijozDelete');

//mijozqoldigi
$router->get('/mijoz-qoldigi', 'QoldiqController@mijozQoldigi');
$router->post('/mijoz-qoldigi', 'QoldiqController@mijozQoldigiCreate');
$router->delete('/mijoz-qoldigi/{id}', 'QoldiqController@mijozQoldigiDelete');

// qarzdorlik
$router->post("/yukberuvchi_qarzi", "QarzdorlikController@yukberuvchi_qarzi");
$router->get("/mijoz_qarzi/{id}", "QarzdorlikController@mijoz_qarzi");
$router->post("/mijozqarzi", "QarzdorlikController@mijozqarzi");
//\\  ||  //\\

//savdo
$router->get('/sotuv-bolimi', 'SavdoController@sotuv');
$router->post('/sotuv-bolimi', 'SavdoController@sotuvCreate');
$router->delete('/sotuv-bolimi/{Id}', 'SavdoController@sotuvDelete');

//agent buyurtma
$router->get('/agent-buyurtma', 'SavdoController@agentBuyurtma');
$router->post('/agent-buyurtma', 'SavdoController@agentBuyurtmaCreate');
$router->post('/agent-sotuv', 'SavdoController@agentSotuv');
$router->get('/agent-sotuv', 'SavdoController@agentBuyurtma');
$router->delete('/agent-buyurtma/{Id}', 'SavdoController@agentBuyurtmaDelete');

//agent tolov
$router->get('/agent-tolov', 'TolovlarController@agentTolov');
$router->post('/agent-tolov', 'TolovlarController@agentTolovCreate');
$router->post('/agent-tolov-accept', 'TolovlarController@agentTolovAccept');
$router->get('/agent-tolov-accept', 'TolovlarController@agentTolov');
$router->delete('/agent-tolov/{Id}', 'TolovlarController@agentTolovDelete');

//mijoz tolov
$router->get('/mijoz-tolov', 'TolovlarController@mijozTolov');
$router->post('/mijoz-tolov', 'TolovlarController@agentTolovAccept');
$router->delete('/mijoz-tolov/{Id}', 'TolovlarController@agentTolovDelete');

//yukBeruvchi tolov
$router->get('/yuk-beruvchi-tolov', 'TolovlarController@yukTolov');
$router->post('/yuk-beruvchi-tolov', 'TolovlarController@yukTolovCreate');
$router->delete('/yuk-beruvchi-tolov/{Id}', 'TolovlarController@yukTolovDelete');
//mijoz buyurtma
$router->get('/mijoz-buyurtma', 'SavdoController@mijozBuyurtma');
$router->post('/mijoz-buyurtma', 'SavdoController@mijozBuyurtmaCreate');
$router->post('/mijoz-otkaz', 'SavdoController@mijozOtkaz');
$router->post('/mijoz-sotuv', 'SavdoController@mijozSotuv');
$router->delete('/mijoz-buyurtma/{Id}', 'SavdoController@mijozBuyurtmaDelete');
// mijoz agents
$router->post('/mijozagents', 'mijozlarController@mijozAgents');

//mijoz vozvrat
$router->get('/mijoz-vozvrat', 'SavdoController@mijozVozvrat');
$router->post('/mijoz-vozvrat', 'SavdoController@mijozVozvratCreate');
$router->delete('/mijoz-vozvrat/{Id}', 'SavdoController@mijozVozvratDelete');

//yukBeruvchi vozvrat
$router->get('/yuk-beruvchi-vozvrat', 'SavdoController@yukBeruvchiVozvrat');
$router->post('/yuk-beruvchi-vozvrat', 'SavdoController@yukBeruvchiVozvratCreate');
$router->delete('/yuk-beruvchi-vozvrat/{Id}', 'SavdoController@yukBeruvchiVozvratDelete');




//dastavchik  tolov
$router->post('/dastavchik-tolov', 'TolovlarController@dastavchikTolovCreate');



//Dostavshik 
$router->get('/dostavshik-buyurtma', 'dostavshikController@index');
$router->get('/dostavshik-buyurtma/{Id}', 'dostavshikController@getBuyurtmaByUser');
$router->post('/dostavshik-buyurtma-holat', 'dostavshikController@updateHolat');
$router->post('/dostavshik-buyurtma-latlng', 'dostavshikController@updateLatLng');

//Hisobot
$router->post('/hisobot/maxsulot-qoldigi', 'HisobotController@ostatkaTovara');
$router->post('/hisobot/mijoz-aktsverka', 'HisobotController@mijozAktsverka');
$router->post('/hisobot/mijozlar-qoldigi', 'HisobotController@mijozlarQoldigi');
$router->post('/hisobot/yuk-beruvchilar-qoldigi', 'HisobotController@yukBeruvchilarQoldigi');
$router->post('/hisobot/yuk-aktsverka', 'HisobotController@yukAktsverka');
$router->post('/hisobot/maxsulot-oborot', 'oborotController@oborotTovara');
$router->post('/hisobot/kassa-hisobi', 'KassaHisobotController@kassaHisobot');
//naklad
$router->post('/hisobot/naklad', 'NakladController@naklad');
$router->post('/hisobot/restrTolov', 'NakladController@restrTolov');



//DTKT
$router->post('/hisobot/dtkt-kontragent', 'DTKTController@DTKT');


//plus minus 
$router->post('/hisobot/plus-minus-ostatka', 'PlusMinusController@ostatkaPlusMinus');
$router->post('/hisobot/plus-minus-mijoz', 'PlusMinusController@mijozPlusMinus');
$router->post('/hisobot/plus-minus-yuk', 'PlusMinusController@yukPlusMinus');
