<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PriblController extends Controller
{
	public function pribl(Request $request) { 
		
	    $sana = $request->json()->get("sana");
	    $sana2 = $request->json()->get("sana2"); 
	       
        $brend_sql = "SELECT
                        tovarlar.brend_id AS brend_id,
                        brendlar.nomi AS nomi,
                        SUM(oborot.jami_miqdor) AS jami_miqdor,
                        SUM(oborot.kirim_som) AS kirim_som,
                        SUM(oborot.kirim_val) AS kirim_val,
                        SUM(oborot.sotish_som) AS sotish_som,
                        SUM(oborot.sotish_val) AS sotish_val
                    FROM
                        (
                        SELECT
                            element_id,
                            SUM(CASE WHEN turi = 2 THEN miqdor ELSE miqdor * -1 END) AS jami_miqdor,
                            SUM(CASE WHEN turi = 2 THEN miqdor * kirim_som ELSE miqdor * kirim_som * -1 END) AS kirim_som,
                            SUM(CASE WHEN turi = 2 THEN miqdor * kirim_val ELSE miqdor * kirim_val * -1 END) AS kirim_val,
                            SUM(CASE WHEN turi = 2 THEN miqdor * sotish_som ELSE miqdor * sotish_som * -1 END) AS sotish_som,
                            SUM(CASE WHEN turi = 2 THEN miqdor * sotish_val ELSE miqdor * sotish_val * -1 END) AS sotish_val
                        FROM
                            `tovar_abarot`
                        WHERE
                            tovar_abarot.time_create >= '$sana' AND tovar_abarot.time_create <= '$sana2'
                        GROUP BY
                            element_id
                    ) AS oborot
                    LEFT JOIN tovarlar ON oborot.element_id = tovarlar.Id
                    LEFT JOIN brendlar ON tovarlar.brend_id = brendlar.Id
                    GROUP BY tovarlar.brend_id";
        		 
		  
    	// tovar sql	 
    	$tovar_sql = "SELECT
                        oborot.*,
                        tovarlar.nomi AS nomi,
                        tovarlar.brend_id AS brend_id
                    FROM
                        (
                        SELECT
                            element_id,
                            SUM(CASE WHEN turi = 2 THEN miqdor ELSE miqdor * -1 END) AS jami_miqdor,
                            SUM(CASE WHEN turi = 2 THEN miqdor * kirim_som ELSE miqdor * kirim_som * -1 END) AS kirim_som,
                            SUM(CASE WHEN turi = 2 THEN miqdor * kirim_val ELSE miqdor * kirim_val * -1 END) AS kirim_val,
                            SUM(CASE WHEN turi = 2 THEN miqdor * sotish_som ELSE miqdor * sotish_som * -1 END) AS sotish_som,
                            SUM(CASE WHEN turi = 2 THEN miqdor * sotish_val ELSE miqdor * sotish_val * -1 END) AS sotish_val
                        FROM
                            `tovar_abarot`
                        WHERE
                            tovar_abarot.time_create >= '$sana' AND tovar_abarot.time_create <= '$sana2'
                        GROUP BY
                            element_id
                        ) AS oborot
                    LEFT JOIN tovarlar ON oborot.element_id = tovarlar.Id
                    WHERE tovarlar.brend_id = ?";
   
		
      $thead1 = [
            ["title"=> "№", "rowspan"=> 1, "colspan"=> 1],
            ["title"=> "Махсулот номи", "rowspan"=> 1, "colspan"=> 1], 
            ["title"=> "Миқдори", "rowspan"=> 1, "colspan"=> 1], 
            ["title"=> "Кирим сумма сўм", "rowspan"=> 1, "colspan"=> 1],
            ["title"=> "Кирим сумма вал", "rowspan"=> 1, "colspan"=> 1],
            ["title"=> "Сотиш сумма сўм", "rowspan"=> 1, "colspan"=> 1],
            ["title"=> "Сотиш сумма вал", "rowspan"=> 1, "colspan"=> 1],
            ["title"=> "Фойда сўм", "rowspan"=> 1, "colspan"=> 1],
            ["title"=> "Фойда вал", "rowspan"=> 1, "colspan"=> 1]
    	];
      
	  
	   //table generator function
	   include(app()->basePath('app'). "/Functions/TableGenerator.php"); 
	   
	   $table = tableGen(theadGen($thead1), $table); 
	   
	   $table = $table."<tbody>";
	   $brendTartib = 1;
	   $tovarTartib = 1;
	   $brend_data = DB::select($brend_sql);  
	   
	   $itog_miqdor = 0;
	   $itog_kirim_som = 0;
	   $itog_kirim_val = 0;
	   $itog_sotish_som = 0;
	   $itog_sotish_val = 0;
	   $itog_foyda_som = 0;
	   $itog_foyda_val = 0;
	   
	   foreach( $brend_data as $brend) {
	       $eachRow = [
	           ["title"=> $brendTartib, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> $brend->nomi, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($brend->jami_miqdor), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true],
	           ["title"=> num_format($brend->kirim_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true],
	           ["title"=> num_format($brend->kirim_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#339966", "bold"=> true],
	           ["title"=> num_format($brend->sotish_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true],
	           ["title"=> num_format($brend->sotish_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#339966", "bold"=> true],
	           ["title"=> num_format($brend->sotish_som - $brend->kirim_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true],
	           ["title"=>  num_format($brend->sotish_val - $brend->kirim_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#FFEAD7", "color"=> "#339966", "bold"=> true],
	       ];
	       $table = tableGen(bodyGen($eachRow), $table);
	       
	       $itog_miqdor = $itog_miqdor +  $brend->jami_miqdor;
	       $itog_kirim_som = $itog_kirim_som +  $brend->kirim_som;
	       $itog_kirim_val = $itog_kirim_val +  $brend->kirim_val;
	       $itog_sotish_som = $itog_sotish_som +  $brend->sotish_som;
	       $itog_sotish_val = $itog_sotish_val +  $brend->sotish_val;
	       $itog_foyda_som = $itog_foyda_som + ($brend->sotish_som - $brend->kirim_som);
	       $itog_foyda_val = $itog_foyda_val + ($brend->sotish_val - $brend->kirim_val);
	       
	       $tovarlar = DB::select($tovar_sql, [$brend->brend_id]);
	       
	       foreach ($tovarlar as $tovar) {
	           
	           $tovarRow = [
	             ["title"=> $tovarTartib, "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> "<div style='width: 350px; padding-left:10px'>".$tovar->nomi."</div>", "rowspan"=> 1, "colspan"=> 1, "align"=> "left", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> $tovar->jami_miqdor, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> num_format($tovar->kirim_som), "rowspan"=> 1,  "wrap"=>true, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> num_format($tovar->kirim_val), "rowspan"=> 1, "wrap"=>true, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> num_format($tovar->sotish_som), "rowspan"=> 1,  "wrap"=>true, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> num_format($tovar->sotish_val), "rowspan"=> 1, "wrap"=>true, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> num_format($tovar->sotish_som - $tovar->kirim_som),  "wrap"=>true,"rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	             ["title"=> num_format($tovar->sotish_val - $tovar->kirim_val),  "wrap"=>true, "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#fff", "color"=> "#000"],
	           ];
	          $table = tableGen(bodyGen($tovarRow), $table);
	           $tovarTartib = $tovarTartib + 1;    
	       }
	       
	           
	       $brendTartib = $brendTartib + 1;    
	   }
	    
	    $jamiRow = [
	           ["title"=> "Жами", "rowspan"=> 1, "colspan"=> 2, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($itog_miqdor), "rowspan"=> 1, "colspan"=> 1, "align"=> "center", "bgColor"=> "#FFEAD7", "color"=> "#000","bold"=>true],
	           ["title"=> num_format($itog_kirim_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "right",  "wrap"=>true, "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true], 
	           ["title"=> num_format($itog_kirim_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "right",  "wrap"=>true, "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true], 
	           ["title"=> num_format($itog_sotish_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "right",  "wrap"=>true, "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true], 
	           ["title"=> num_format($itog_sotish_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "wrap"=>true, "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true], 
	           ["title"=> num_format($itog_foyda_som), "rowspan"=> 1, "colspan"=> 1, "align"=> "right",  "wrap"=>true, "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true], 
	           ["title"=> num_format($itog_foyda_val), "rowspan"=> 1, "colspan"=> 1, "align"=> "right", "wrap"=>true, "bgColor"=> "#FFEAD7", "color"=> "#536ac2", "bold"=> true], 
	       ];
	   
	    $table = tableGen(bodyGen($jamiRow), $table);
	       
	   $table = $table."</tbody>";
	  
	  $table = $table."</table></body></html>";
	   $html =  $styles."<div class='print_header_hisobot'> <h2>Маҳсулот фойдаси</h2><h5>".$sana." - ".$sana2." давр ичида</h5> </div><table id='customers'>".$table;
	   return ["html"=> $html];
    }
    
   
}




